/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileReadPacket;
import com.ibm.hsc.filesvr.FsFileReadRequestPacket;
import com.ibm.hsc.filesvr.FsPacket;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FsFileReadResponsePacket
extends FsFileReadPacket {
    protected byte[] m_readBuffer = null;

    public FsFileReadResponsePacket(FsConnection fsConnection) {
        super(fsConnection);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsConnection fsConnection, long l, int n, long l2) {
        super(fsConnection, l, n, l2);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsConnection fsConnection, long l, int n, int n2, long l2) {
        super(fsConnection, l, n, n2, l2);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsConnection fsConnection, long l, int n, int n2, int n3, String string) {
        super(fsConnection, l, n, n2, n3, string);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsPacket fsPacket) {
        super(fsPacket);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsPacket fsPacket, long l, int n, long l2) {
        super(fsPacket, l, n, l2);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsPacket fsPacket, long l, int n, int n2, long l2) {
        super(fsPacket, l, n, n2, l2);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsPacket fsPacket, long l, int n, int n2, int n3, String string) {
        super(fsPacket, l, n, n2, n3, string);
        this.setRequestPacket();
    }

    public FsFileReadResponsePacket(FsFileReadPacket fsFileReadPacket) {
        super(fsFileReadPacket);
        this.setResponsePacket();
    }

    public FsFileReadResponsePacket(FsFileReadRequestPacket fsFileReadRequestPacket) {
        super(fsFileReadRequestPacket);
        this.setResponsePacket();
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (!this.isResponsePacket()) {
            throw new FsException(20);
        }
        try {
            RandomAccessFile randomAccessFile;
            if ((this.m_fileAction & 1) != 0) {
                this.m_fileHandle = this.m_connection.openFile(this.m_fileType, this.m_fileName, true);
            }
            if ((randomAccessFile = this.m_connection.getOpenFile(this.m_fileHandle)) == null) {
                throw new FsException(256);
            }
            long l = randomAccessFile.length();
            if (l <= this.m_readOffset) {
                throw new FsException(27, this.m_readOffset, l);
            }
            if (l < this.m_readOffset + (long)this.m_readLength) {
                this.m_readLength = (int)(l - this.m_readOffset);
            }
            randomAccessFile.seek(this.m_readOffset);
            if (this.m_readLength < 0) {
                throw new FsException(29, this.m_readLength);
            }
            this.m_readBuffer = new byte[this.m_readLength];
            randomAccessFile.read(this.m_readBuffer);
            if ((this.m_fileAction & 4) != 0) {
                this.m_connection.closeFile(this.m_fileHandle);
            }
            fsByteStream.writeInt(this.m_fileAction);
            fsByteStream.writeInt(this.m_readBuffer.length);
            switch (this.m_fileAction) {
                case 1: {
                    fsByteStream.writeLong(this.m_fileHandle);
                }
                case 0: 
                case 4: 
                case 5: {
                    fsByteStream.writeBytes(this.m_readBuffer);
                    break;
                }
                default: {
                    throw new FsException(28);
                }
            }
        }
        catch (IOException iOException) {
            this.m_connection.trace("FsFileReadResponse.buildData: Exception caught", iOException);
            throw new FsException(768);
        }
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (!this.isResponsePacket()) {
            throw new FsException(20);
        }
        this.m_fileAction = fsByteStream.readInt();
        this.m_readLength = fsByteStream.readInt();
        if (this.m_readLength < 0) {
            throw new FsException(29, this.m_readLength);
        }
        switch (this.m_fileAction) {
            case 1: {
                this.m_fileHandle = fsByteStream.readLong();
            }
            case 0: 
            case 4: 
            case 5: {
                if (this.m_readLength <= fsByteStream.available()) {
                    this.m_readBuffer = new byte[this.m_readLength];
                    fsByteStream.readBytes(this.m_readBuffer);
                    break;
                }
                throw new FsException(17);
            }
            default: {
                throw new FsException(28, this.m_fileAction);
            }
        }
    }

    public byte[] getReadBytes() {
        return this.m_readBuffer;
    }
}

